package econom;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.TreeSet;

import javax.imageio.ImageIO;

// Ott@C
class EconomGraph {


	// Ot\pHTMLt@C
	public void createHTML(String csvFileName){
	
		try {
		
			FileWriter writer = new FileWriter(
					new File(csvFileName + ".html"), true);
			
			BufferedWriter bw = new BufferedWriter(writer);
			
			// fBNg폜
			String[] imgFileName = csvFileName.split("\\\\", 0); 
			
			bw.append("<html>\n");
			bw.append("<body>\n");
			bw.append("B<br>\n");
			bw.append("<img src=\"" + imgFileName[2] + ".bmp\" />\n");
			bw.append("<br>\n");

			bw.append("i<br>\n");
			bw.append("<img src=\"" + imgFileName[2] + ".goods.bmp\" />\n");
			bw.append("<br>\n");

			bw.append("<br>\n");
			bw.append("<img src=\"" + imgFileName[2] + ".wage.bmp\" />\n");
			bw.append("<br>\n");
			
			bw.append("</body>\n");
			bw.append("</html>\n");
			
			bw.close();
			writer.close();
			
		} catch (IOException e) {
			e.printStackTrace();
			System.exit(-1);
		}		
		
	}	
	

	// YE̔ʃOt\@͌CSVt@C
	public void createGraphWage(String csvFileName){
		
		// CSVf[^Ǎ
		ArrayList dataList = new ArrayList();
		readCSV(csvFileName, dataList);
		
		// TODO@s񐔁Aʃf[^͈̔͂AIɐ
		// Ot摜TCY̌
		int canvasSizeX = 500;
		int canvasSizeY = 500;
		BufferedImage image = new BufferedImage(
				canvasSizeX, canvasSizeY, BufferedImage.TYPE_INT_RGB);
		//BufferedImage image = ImageIO.read(new File("xxx.bmp"));
		Graphics2D g2 = image.createGraphics();
		// wiF
		g2.setBackground(Color.gray);
		g2.clearRect(0, 0, canvasSizeX, canvasSizeY);
		
		// _W(0,0)
		g2.setColor(Color.black);
		int graphX0 = 50;
		int graphY0 = canvasSizeY/2;
		int spanX = 10;	// e_̊Ԋu

		// ObhԊu
		int gridSpan = 50;
		int gridLoop = canvasSizeX / gridSpan;
		g2.setColor((new Color(100, 100, 100)));
		for(int i=0; i < gridLoop; i++) {
			g2.drawLine(graphX0 + i*gridSpan, 0, graphX0 + i*gridSpan, canvasSizeY);
			if(i != 0) {
				g2.drawString(Integer.toString(i*5), graphX0 + i*gridSpan, graphY0+11);
			}
		}

		// XP[
		double graphScale = 1.0;
		// w̍ől擾
		int maxVal = getMaxVal(dataList, 18, true);	// A
		maxVal = Math.max(maxVal, getMaxVal(dataList, 29, true)); // B
		if((maxVal != -77777) && (canvasSizeY/2 <= maxVal)) {
			// Ot̏ɕ\̂ 0.5i]Tājɂ
			graphScale = (double)(canvasSizeY*0.45) / (double)maxVal;
		}
		
		// 
		g2.setColor(Color.black);
		g2.drawLine(0, graphY0, canvasSizeX, graphY0);
		g2.drawLine(graphX0, 0, graphX0, canvasSizeY);
		g2.drawString("0", graphX0-15, graphY0+11);
		
		// ⏕
		g2.setColor(Color.black);
		g2.drawString("A", 5, graphY0-50);
		g2.drawString("B", 5, graphY0+55);

		g2.setColor(Color.green);
		g2.drawString("wzv", 1, canvasSizeY/4-15);
		
		g2.setColor(Color.yellow);
		g2.drawString("iA̍wz", 1, canvasSizeY/4+15);

		
		
		// 㑤Ot@
		draw1Line(dataList, g2, Color.pink, graphX0 ,graphY0, spanX, graphScale, 
				18, true, true, "");

		// 㑤Ot@w
		draw2Line(dataList, g2, graphX0 ,graphY0, spanX, graphScale, 
				4, 10, 8, 11, true);
		
		// Ot@
		draw1Line(dataList, g2, Color.pink, graphX0 ,graphY0, spanX, graphScale, 
				29, true, false, "");
		
		// Ot
		draw2Line(dataList, g2, graphX0 ,graphY0, spanX, graphScale, 
				4, 21, 8, 22, false);
		
		try {
			// t@Cۑ
			ImageIO.write(image, "bmp", new File(csvFileName + ".wage.bmp"));
			
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
	
	// P̐` @́AOtɂԍ@l̗L@㑤@
	private void draw1Line(ArrayList dataList, Graphics2D g2, Color lineColor,
			int graphX0 ,int graphY0, int spanX, double graphScale,
			int line1col1, boolean haveFirstVal, boolean isUpper, String subscript) {
		
		int preX = graphX0;
		int preY = graphY0;
		int valY, drawY;
		String line;

		// Y̏l
		if(haveFirstVal) {
			
			if(isUpper) {
				preY = graphY0 - (int)(getDrawPointY(
						(String)dataList.get(1), line1col1) * graphScale);
			}else {
				preY = graphY0 + (int)(getDrawPointY(
						(String)dataList.get(1), line1col1) * graphScale);
			}
			// ⏕
			g2.setColor(Color.pink);
			// s
			if(subscript.length() > 4) {
				// Sڂ܂łPs
				g2.drawString(subscript.substring(0, 4), 0, preY);
				g2.drawString(subscript.substring(4), 0, preY+15);
			} else if(subscript.length() < 3) {
				g2.drawString(subscript, graphX0-30, preY);
			} else {
				g2.drawString(subscript, 0, preY);
			}
		}
		
		TreeSet valSet = new TreeSet();
		
		// PersonA  
		for(int i=0; i < dataList.size(); i++) {
			
			if(i == 0) {
				continue;	// ʃt@ĈPs
			}
			
			line = (String)dataList.get(i);
			
			// `悷l̎擾
			if((valY = getDrawPointY(line, line1col1)) == -77777) {
				break;
			}
			
			// `悷YW
			if(isUpper) {
				drawY = graphY0 - (int)(valY * graphScale);
			} else {
				drawY = graphY0 + (int)(valY * graphScale);
			}
			
			// dȂ悤ɐl\
			g2.setColor(Color.cyan);
			if(valSet.add(Integer.valueOf(drawY))) {
				g2.drawString(Integer.toString(valY), preX+spanX, drawY);
			}
			
			// x1 y1, x2 y2
			g2.setColor(lineColor);
			g2.drawLine(preX, preY, preX+spanX, drawY);
			
			preX += spanX;
			preY = drawY;
		}		
	}
	
	// Q̗̒l|iFz*ʁjAQ̐`A̒Sn_
	// lineXcol2@-1nƁA|킹lineXcol1̃Ot𐶐B
	private void draw2Line(ArrayList dataList, Graphics2D g2, 
			int graphX0 ,int graphY0, int spanX, double graphScale,
			int line1col1, int line1col2, int line2col1, int line2col2, 
			boolean isUpper) {
		
		// 
		int preX = graphX0;
		int preY = graphY0;
		int preYgoodsA = graphY0;
		int col2, valYline1, valYline2, drawYline1, drawYline2;
		TreeSet valSet = new TreeSet();
		
		String line;
		
		// Qނ̃C`
		for(int i=0; i < dataList.size(); i++) {
			
			if(i == 0) {
				continue;	// ʃt@ĈPs
			}
			
			line = (String)dataList.get(i);

			// CP P*Q
			if((valYline1 = getDrawPointY(line, line1col1)) == -77777) {
				break;
			}
			if(line1col2 == -1) {
				col2 = 1;	// col2pȂ
			} else {
				if((col2 = getDrawPointY(line, line1col2)) == -77777) {
					break;
				}
			}
			valYline1 = valYline1 * col2;

			// @R*S			
			if((valYline2 = getDrawPointY(line, line2col1)) == -77777) {
				break;
			}			
			if(line2col2 == -1) {
				col2 = 1;	// col2pȂ
			} else {			
				if((col2 = getDrawPointY(line, line2col2)) == -77777) {
					break;
				}
			}
			valYline2 = valYline2 * col2;
			// line2@(total)
			valYline2 += valYline1;
			
			// `悷YW
			if(isUpper) {
				drawYline1 = graphY0 - (int)(valYline1 * graphScale);
				drawYline2 = graphY0 - (int)(valYline2 * graphScale);
			} else {
				drawYline1 = graphY0 + (int)(valYline1 * graphScale);
				drawYline2 = graphY0 + (int)(valYline2 * graphScale);
			}
			
			// dȂ悤ɐl\
			g2.setColor(Color.cyan);
			if(valSet.add(Integer.valueOf(drawYline1))) {
				g2.drawString(Integer.toString(valYline1), preX+spanX, drawYline1);
			}
			if(valSet.add(Integer.valueOf(drawYline2))) {
				g2.drawString(Integer.toString(valYline2), preX+spanX, drawYline2);
			}

			// line1
			g2.setColor(Color.yellow);
			g2.drawLine(preX, preYgoodsA, preX+spanX, drawYline1);
			
			// line2 
			g2.setColor(Color.green);
			g2.drawLine(preX, preY, preX+spanX, drawYline2);
			
			preX += spanX;
			preY = drawYline2;
			preYgoodsA = drawYline1;
		}		
	}	
	
	// YE̔ʃOt\@͌CSVt@C
	public void createGraphGoods(String csvFileName){
		
		// CSVf[^Ǎ
		ArrayList dataList = new ArrayList();
		readCSV(csvFileName, dataList);
		
		// TODO@s񐔁Aʃf[^͈̔͂AIɐ
		// Ot摜TCY̌
		int canvasSizeX = 500;
		int canvasSizeY = 600;
		BufferedImage image = new BufferedImage(
				canvasSizeX, canvasSizeY, BufferedImage.TYPE_INT_RGB);
		//BufferedImage image = ImageIO.read(new File("xxx.bmp"));
		Graphics2D g2 = image.createGraphics();
		// wiF
		g2.setBackground(Color.gray);
		g2.clearRect(0, 0, canvasSizeX, canvasSizeY);
		
		// _W(0,0)
		g2.setColor(Color.black);
		int graphX0 = 50;
		int graphY0 = canvasSizeY/2;
		int spanX = 10;	// e_̊Ԋu

		// ObhԊu
		int gridSpan = 50;
		int gridLoop = canvasSizeX / gridSpan;
		g2.setColor((new Color(100, 100, 100)));
		for(int i=0; i < gridLoop; i++) {
			g2.drawLine(graphX0 + i*gridSpan, 0, graphX0 + i*gridSpan, canvasSizeY);
			if(i != 0) {
				g2.drawString(Integer.toString(i*5), graphX0 + i*gridSpan, graphY0+11);
			}
		}
		
		// XP[
		double graphScale = 1.0;
		// w̍ől擾
		int maxVal = getMaxVal(dataList, 3, true);	// iAY
		maxVal = Math.max(maxVal, getMaxVal(dataList, 7, true)); // iBY
		if((maxVal != -77777) && (canvasSizeY/2 <= maxVal)) {
			// Ot̏ɕ\̂ 0.5i]Tājɂ
			graphScale = (double)(canvasSizeY*0.45) / (double)maxVal;
		}
		
		// 
		g2.setColor(Color.black);
		g2.drawLine(0, graphY0, canvasSizeX, graphY0);
		g2.drawLine(graphX0, 0, graphX0, canvasSizeY);
		g2.drawString("0", graphX0-15, graphY0+11);
		
		// ⏕
		g2.setColor(Color.black);
		g2.drawString("iA", 5, graphY0-50);
		g2.drawString("iB", 5, graphY0+55);	// TODO@iɂ
		g2.setColor(Color.green);
		g2.drawString("̔ʍv", 1, canvasSizeY/4-15);
		g2.setColor(Color.yellow);
		g2.drawString("A̍w", 1, canvasSizeY/4+15);
		
		
		// 㑤Ot@Y
		draw1Line(dataList, g2, Color.pink, graphX0 ,graphY0, spanX, graphScale, 
				3, true, true, "Y ij");

		// 㑤Ot@̔
		draw2Line(dataList, g2, graphX0 ,graphY0, spanX, graphScale, 
				10, -1, 21, -1, true);
		
		// Ot@Y
		draw1Line(dataList, g2, Color.pink, graphX0 ,graphY0, spanX, graphScale, 
				7, true, false, "Y ij");

		// Ot ̔
		draw2Line(dataList, g2, graphX0 ,graphY0, spanX, graphScale, 
				11, -1, 22, -1, false);

		try {
			// t@Cۑ
			ImageIO.write(image, "bmp", new File(csvFileName + ".goods.bmp"));
			
		} catch (IOException e) {
			e.printStackTrace();
		}		
		
	}
	
	// BOt쐬@͌CSVt@C
	public void createGraphAchievement(String csvFileName){

		// CSVf[^Ǎ
		ArrayList dataList = new ArrayList();
		readCSV(csvFileName, dataList);

		// TODO@s񐔁Aʃf[^͈̔͂AIɐ 
		// Ot摜TCY̌
		int canvasSizeX = 500;
		int canvasSizeY = 230;
		BufferedImage image = new BufferedImage(
				canvasSizeX, canvasSizeY, BufferedImage.TYPE_INT_RGB);
		//BufferedImage image = ImageIO.read(new File("xxx.bmp"));
		Graphics2D g2 = image.createGraphics();
		// wiF
		g2.setBackground(Color.gray);
		g2.clearRect(0, 0, canvasSizeX, canvasSizeY);
		
		// _W(0,0)
		g2.setColor(Color.black);
		int graphX0 = 50;
		int graphY0 = canvasSizeY/2;
		int spanX = 10;	// e_̊Ԋu@TODO scaleɑΉĂȂ

		// XP[
		double graphScale = 1.0;
		// w̍ől擾
		int maxVal = 100; // ől100(%)
		if((maxVal != -77777) && (canvasSizeY/2 <= maxVal)) {
			// Ot̏ɕ\̂ 0.5i]Tājɂ
			graphScale = (double)(canvasSizeY*0.45) / (double)maxVal;
		}
		
		// Obh
		int gridSpan = 50;
		int gridLoop = canvasSizeX / gridSpan;
		g2.setColor((new Color(100, 100, 100)));
		for(int i=0; i < gridLoop; i++) {
			g2.drawLine(graphX0 + i*gridSpan, 0, graphX0 + i*gridSpan, canvasSizeY);
			if(i != 0) {
				g2.drawString(Integer.toString(i*5), graphX0 + i*gridSpan, graphY0+11);
			}
		}

		// ⏕
		g2.setColor(Color.pink);
		g2.drawString("100%", 1, graphY0+111);
		g2.drawString("100%", 1, graphY0-101);
		g2.drawString("B", 1, graphY0-115);
		g2.setColor(Color.black);
		g2.drawString("A", graphX0-15, graphY0-50);
		g2.drawString("B", graphX0-15, graphY0+55);
		
		// 
		g2.setColor(Color.black);
		g2.drawLine(0, graphY0, canvasSizeX, graphY0);
		g2.drawLine(graphX0, 0, graphX0, canvasSizeY);
		g2.drawString("0", graphX0-15, graphY0+11);
		
		// 100% C
		g2.setColor(Color.pink);
		drawScaledLine(g2, graphScale, Color.pink, 
				graphX0, canvasSizeX, graphY0, 100, true);
		drawScaledLine(g2, graphScale, Color.pink, 
				graphX0, canvasSizeX, graphY0, 100, false);
		
		// 㑤Ot@B
		draw1Line(dataList, g2, Color.green, graphX0 ,graphY0, spanX, graphScale, 
				19, false, true, "B");

		// Ot@B
		draw1Line(dataList, g2, Color.green, graphX0 ,graphY0, spanX, graphScale, 
				30, false, false, "B");
		
		try {
			// t@Cۑ
			ImageIO.write(image, "bmp", new File(csvFileName + ".bmp"));
			
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
	
	// XP[ɑΉ`  drawY=`悷lY, centerY=̒SʒuY
	private void drawScaledLine(Graphics2D g2, double scale, Color color, 
			int startX, int endX, int centerY, int drawY, boolean isUpper) {
		g2.setColor(color);
		
		if(isUpper) {
			g2.drawLine(startX, centerY-(int)(drawY*scale), 
					endX, centerY-(int)(drawY*scale));
		} else {
			g2.drawLine(startX, centerY+(int)(drawY*scale), 
					endX, centerY+(int)(drawY*scale));
		}
	}
	
	// csvt@Clistɓǂݍ
	private void readCSV(String csvFileName, ArrayList list) {
		
		try {		
			File csvfile = new File(csvFileName);
			if(!csvfile.exists()) {
				System.out.println("Error: sCSVt@C܂ \n"
					+ "t@C: " + csvFileName + "\n");
				System.exit(-1);
			}
			FileReader reader = new FileReader(csvfile);
			BufferedReader br = new BufferedReader(reader);
			
			// es
			String tmpLine = "";
			for(int loop=0; tmpLine != null; loop++) {
				tmpLine = br.readLine();
				list.add(tmpLine);
			}
			
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	// Xg̎w̍őlԂ 
	// Xgɐl݂ȂƂ error -77777
	private int getMaxVal(ArrayList list, int col, boolean skipFirstLine) {

		String line;
		int returnVal = -77777;
		
		for(int i=0; i < list.size(); i++) {
			
			if((i == 0) && skipFirstLine) {
				continue;	// ʃt@ĈPs
			}
			
			line = (String)list.get(i);
			
			if(line != null && !line.equals("")){
				
				String[] params = line.split(",");
				
				if(params[col] != null && !params[col].equals("")) {					
					returnVal = Math.max(returnVal, Integer.parseInt(params[col]));
				}
			}		
		}
		return returnVal;
	}
	
	// csvf[^colɊւāA|CgYWԂ TODO int^ł悢
	private int getDrawPointY(String line, int col) {

		int pointY = -77777;	// error
		
		if(line != null && !line.equals("")){
			
			String[] params = line.split(",");	
			if(params[col] != null && !params[col].equals("")) {
				pointY = Integer.parseInt(params[col]);
			}
		}
		
		return pointY;
	}
}
