package econom;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Random;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;


/* 
 * Program : Econom
 * Version : 1.0  
 * Author : Gonta(gonta@teginkei.info)
 * 
 * <XV>
 * 1.0  : ܂̓lbgɒuĂ݂B(2012/2/17)
 * 
 * <g>
 * RpCƎsɂ́AEclipsegĂB
 * javãvWFNgĂRjava\[Xt@Cۑ܂B
 * vO\[X̐擪ɂSettingNX́AfBNgƃt@CݒB
 * 
 * <eXgf[^̎Ql>
 * 3000,2000,200,300,175,50,1,150,70,1
 * ̂PseXgf[^t@CɏłBl͍珇ɁA
 * A,B,YA,YB,i`v,iav,A,i`v,iav,B
 * 
 */


class Setting {
	
	// ftHgl@TODO ݒt@Cŏ㏑\
	static String INPUT_DIR = "D:\\econom_data\\"; // eXgf[^̕ۑtH_
	static String TEST_DATA = "testdata.csv"; 		// eXgf[^t@C̖	
	static String OUTPUT_DIR = "D:\\econom_data\\"; // ʃt@C̏o͐

	static long trialTime = 30;		// s
	
	static int debugLevel = 1;	// fobOpo̗͂L
	static int debugStoryLevel = 2; 

	static String productNameA = "Apple";	// iA
	static String productNameB = "Salmon";	// iB
	
	static boolean exchangeRandom = true;	// [F Ԃ_ɕύX
	static int decreaseLaborRate = 80;		// % iJʁj炵Ă悢Bx	
	static boolean balanceForward = false;	// Jz true=L	
	static boolean skip_first_line = true;	// eXgf[^t@C1sڂȂtrue
	
}

// 
class Econom {

	public static void main(String args[]) {
		
		// csvo̓fBNg
		File output_dir = new File(Setting.OUTPUT_DIR);
		if(!output_dir.exists()) {
			output_dir.mkdir();
		}
		// V~[V̎s
		//EconomMain mainloop = new EconomMain(
		//	2000,2000,100,100,50,50,1.0,50,50,1.0);
		// mainloop.setout();
		
		// eXgf[^t@CǍŎs
		TestData data = new TestData();
			
		for(long trialNo = 0; trialNo < data.getSize(); trialNo++) {
			// csvf[^1sǂݍ
			data.setNext();
			
			// RXgN^ɍ킹ăLXgKv
			EconomMain mainloop = new EconomMain(
					trialNo,
					(long)data.a, 
					(long)data.b, 
					(long)data.c, 
					(long)data.d, 
					(long)data.e, 
					(long)data.f, 
					data.g, 
					(long)data.h, 
					(long)data.i, 
					data.j);
			
			String csvFileName = mainloop.setout();
			
			// CSVt@COt𐶐
			EconomGraph g = new EconomGraph();
			g.createGraphAchievement(csvFileName);
			g.createGraphGoods(csvFileName);
			g.createGraphWage(csvFileName);
			g.createHTML(csvFileName);
		}
	}
}		


// C[v
class EconomMain {

	Factory factoryA;
	Factory factoryB;
	Person personA;
	Person personB;
	Market market = new Market();
	ArrayList systemFactoryList = new ArrayList();
	
	//**********************
	private long trialNo = 0;
	Date filename_date = new Date();
	String csvFilename = "";

	private long initDemandProductA_A;	
	private long initDemandProductB_A;	
	private long initDemandProductA_B;	
	private long initDemandProductB_B;	

	// RXgN^@^`ɒ
	EconomMain(long trialNo, // sԍ
			long initWageA,	// A
			long initWageB,		// B
			long initQuantityA,	// YA
			long initQuantityB,	// YB
			long initDemandProductA_A,	// i`v
			long initDemandProductB_A,	// iav
			double consumerPropensity_A, // A
			long initDemandProductA_B,	// i`v
			long initDemandProductB_B,	// iav
			double consumerPropensity_B) {	// B
		
		this.trialNo = trialNo;
		this.factoryA = new Factory("FA");
		this.factoryB = new Factory("FB");
		
		// V~[V̐ݒ
		this.personA = new Person("PA", initWageA, consumerPropensity_A); 
		this.personB = new Person("PB", initWageB, consumerPropensity_B); 
		this.initDemandProductA_A = initDemandProductA_A;	
		this.initDemandProductB_A = initDemandProductB_A;	
		this.initDemandProductA_B = initDemandProductA_B;	
		this.initDemandProductB_B = initDemandProductB_B;

		// io^@Yʂݒ
		factoryA.addProduct(Setting.productNameA, initQuantityA, 0);
		factoryB.addProduct(Setting.productNameB, initQuantityB, 0);
	}
	
	//**********************
	
	// VXepIuWFNgXg@f[^擾p
	private void createObject() {
		systemFactoryList.add(factoryA);
		systemFactoryList.add(factoryB);
	}	
	
	//@C[v
	public String setout() {
		
		// IuWFNg
		createObject();
		
		// lݒ
		initParam();
		
		// 
		factoryA.entry(personA);
		factoryB.entry(personB);

		for(long i=0; i < Setting.trialTime; i++) {

DU.s1(i + "ڂ̒Jn܂B");
DU.s1("YH"+factoryA.name+"ŏi𐶎Y܂B");
			// Y
			GoodsList goodsListA = factoryA.produce();
DU.s1("YH"+factoryB.name+"ŏi𐶎Y܂B");
			GoodsList goodsListB = factoryB.produce();
			
DU.s1("sŎ鏤i̍݌ɂo^܂B");
			// sŎisԂ̋ȂEsÏړRXgȂj
			market.setStockList(goodsListA);	// ݌ɏi̐ݒ
			market.setStockList(goodsListB);	// ݌ɏi̐ݒ

			// sɎQ
			market.entry(personA);
			market.entry(personB);

DU.s1("sɏ҂KAws܂B");
			// 
			market.exchange();

DU.s1("ʂ\܂B");
			printStat(market, i);

DU.s1("YH"+factoryA.name+"Œs܂B");
			// tB[hobN
			factoryA.feedback(market);
DU.s1("YH"+factoryB.name+"Œs܂B");
			factoryB.feedback(market);

DU.s1("lݒ肵܂B");
			// vʁE݌ɂ̏
			initParam();
		}
		
		return this.csvFilename;
	}
	
	// lݒŏ
	private void initParam() {
		
		// vʂ̐ݒ
		personA.consumer.clearDemandList();
		personB.consumer.clearDemandList();
		personA.consumer.setDemand(Setting.productNameA, this.initDemandProductA_A);
		personA.consumer.setDemand(Setting.productNameB, this.initDemandProductB_A);
		personB.consumer.setDemand(Setting.productNameA, this.initDemandProductA_B);
		personB.consumer.setDemand(Setting.productNameB, this.initDemandProductB_B);

		// vBXg̃NA
		personA.consumer.clearDemandComplaint();
		personB.consumer.clearDemandComplaint();
		
		// BxvZpXg̃NA
		personA.consumer.clearPurchaseList();
		personB.consumer.clearPurchaseList();
		
		market.clearEntryList();	// ڋq
		market.clearStockList();	// ݌0
	}
	
	// Wvo
	private void printStat(Market m, long roop) {
		
		// 
		String title = ",";
		String msg = roop + ",";
	
		// F,i,Y,i
		for(int i=0; i < systemFactoryList.size(); i++) {
			Factory f = (Factory)systemFactoryList.get(i);
			
			title += "F,i,Y,i,";
			for(int j=0; j < f.productList.getSize(); j++)	{
				Goods g = f.productList.getGoods(j);
				msg += f.name + "," + 
						g.name + "," + g.number +"," + g.price + ",";
			}
		}

		// Name, ǉvA, ǉvB, s, zc, , Bx
		for(int i=0; i < m.getEntryList().getSize(); i++) {
			Person p = m.getEntryList().getPerson(i);
	
			title += "P,"; 
			msg += p.name + ",";

			// w
			GoodsList purchaseList = p.consumer.printList(2, false);
			for(int j= 0; j < m.getStockList().getSize(); j++) {
								
				String goodsName = m.getStockList().getGoods(j).name;
				title += "w" + goodsName +","; 
				if(purchaseList.getGoods(goodsName) != null) {
					msg += purchaseList.getGoods(goodsName).number + ",";
				} else {
					msg += "0,";
				}
			}
			
			// Bv
			GoodsList demandList = p.consumer.printList(1, false);
			for(int j= 0; j < m.getStockList().getSize(); j++) {
				
				String goodsName = m.getStockList().getGoods(j).name;
				title += "Bv" + goodsName +","; 
				if(demandList.getGoods(goodsName) != null) {
					msg += demandList.getGoods(goodsName).number + ",";
				} else {
					msg += "0,";
				}
			}
			
			// ǉv
			GoodsList demandComplaintList = p.consumer.printList(3, false);
			for(int j= 0; j < m.getStockList().getSize(); j++) {
								
				String goodsName = m.getStockList().getGoods(j).name;
				title += "ǉv" + goodsName +","; 
				if(demandComplaintList.getGoods(goodsName) != null) {
					msg += demandComplaintList.getGoods(goodsName).number + ",";
				} else {
					msg += "0,";
				}
			}

			title += "s,zc,,Bx,";
			msg += p.consumer.wageComplaint + ",";
			msg	+= p.consumer.wallet + ",";
			msg	+= p.labor.getWage() + ",";
			msg	+= (int)p.consumer.getAchievement();	// \
			msg	+= ",";
		}
		
		if(roop == 0) {
			DU.d1(title,true);
			createCSV(title + "\n");
		}
		DU.d1(msg, true);
		createCSV(msg + "\n");

	}
	
	private void createCSV(String msg) {

		try {
			// ǉ
			SimpleDateFormat filenameFormat = new SimpleDateFormat("yyyyMMdd_HHmmss");
			
			this.csvFilename = Setting.OUTPUT_DIR 
					+ filenameFormat.format(filename_date) 
					+ "_" + Long.toString(trialNo) + ".csv";
			
			FileWriter writer = new FileWriter(
					new File(this.csvFilename), true);
			
			BufferedWriter bw = new BufferedWriter(writer);
			bw.append(msg);
			bw.close();
			writer.close();
			
		} catch (IOException e) {
			e.printStackTrace();
			System.exit(-1);
		}
	}
	
	// YHNX
	class Factory {
		
		String name = "";
		
		Factory(String name) {
			this.name = name;
		}
		
		long WAGE = 0; 	// YH̎xv
		
		// Yꗗ\
		private GoodsList productList = new GoodsList();
			
		// io^
		public void addProduct(String name, long number, long price) {
			productList.addGoods(new Goods(name, number, price));
		}
		
		// ЈXg
		private PersonList laborList = new PersonList();
		
		// 
		public void entry(Person person) {
			laborList.addPerson(person);
		}

		// Y@߂l͐YGoodsList
		public GoodsList produce() {
			
			// x
			WAGE = 0;
			for(int i=0; i < laborList.getSize(); i++) {
				Person p = laborList.getPerson(i);
				WAGE += p.labor.getWage();
			}
DU.s2("̒́A"+WAGE);

			// Y i1YHŁAPނ̏i𐶎Y邱Ƃzj
			long totalNum = 0;
			for(int i=0; i < productList.getSize(); i++) {
				totalNum += productList.getGoods(i).number;
			}
DU.s2("̐Yʂ́A"+totalNum);
			for(int i=0; i < productList.getSize(); i++) {

				// iPݒ@Jʂɔ䗦z\ȉi
				// _ȉ؎̂Ăőiݒ肳
				if(totalNum != 0){
					productList.getGoods(i).price = Math.max(WAGE / totalNum, 1);
DU.s2("i"+productList.getGoods(i).name+"̉i"+productList.getGoods(i).price);
				} else {
					System.out.println("Error: product number is 0");
					System.exit(-1);
				}
				
				productList.getGoods(i).maker = this.name;
			}
			
			// marketŔ̔鏤i
			GoodsList outputProduct = new GoodsList();
			productList.copyList(outputProduct);
			
			return outputProduct;
		}

		// 
		public void feedback(Market market) {
			
			// YpXg
			GoodsList adjustList = new GoodsList();
			
			// Bx
			// ֋XAs̑SĂ̎Q҂̎vsXg擾
			PersonList personList = market.getEntryList();
			for(int i=0; i < personList.getSize(); i++) {
				Person person = personList.getPerson(i);

				// sF
				long listSize = person.consumer.demandComplaint.getSize();
				if(listSize > 0) {
					for(int j=0; j < listSize; j++) {
						Goods tmpGoods = person.consumer.demandComplaint.getGoods(j);
						// ̐YHŐYĂ鏤ȉꍇ
						if(productList.getGoods(tmpGoods.name) != null) {
							// Y@
							adjustList.addGoods(new Goods(
									tmpGoods.name ,tmpGoods.number, tmpGoods.price));
DU.s2("Y悤Ǝvi" + tmpGoods.name + "ŁA݌v" + adjustList.getGoods(tmpGoods.name).number + "");
						} /*else {// 戵i}*/
					}
				}
			}
			
			// sF
			for(int i=0; i < laborList.getSize(); i++) {
				// ̐YHentryĂ]ƈ
				Person labor = laborList.getPerson(i);
				if(labor.consumer.wageComplaint > 0) {

					// Yʂ̑
					for(int j=0; j < adjustList.getSize(); j++) {
						Goods adjustGoods = adjustList.getGoods(j);
					
						if(adjustGoods.number > 0) {
							// Y
							long adjustNumber = labor.consumer.wageComplaint
												/ adjustGoods.price;
							// Yʂ͏ɂ킹
							adjustNumber = Math.min(adjustNumber, adjustGoods.number);
DU.s2("s̘J҂Ƒk" + adjustGoods.name + "" + adjustNumber + "AY鎖ɂ܂B"+"P"+adjustGoods.price);

							productList.addGoods(new Goods(adjustGoods.name, 
									adjustNumber, adjustGoods.price));
							
							// ㏸
//	͒ǉiv̍v狟𑝉悤ƂāAJ҂̏v̍v傫΁AB
//	2iv̕sAPi̐Y̒ŏC悤ƂB						
							labor.labor.setWage(labor.labor.getWage() 
									+ (adjustNumber * adjustGoods.price));
							labor.consumer.wageComplaint -= adjustNumber * adjustGoods.price;

							adjustGoods.number -= adjustNumber;
							
//	YʕύX
DU.s2("J"+labor.name+"̒́A"+ adjustNumber * adjustGoods.price +"A"+labor.labor.getWage()+"ɂȂ܂B");
DU.s2("i"+adjustGoods.name+"̐Yʂ́A"+productList.getGoods(adjustGoods.name).number+"ɒ܂B");
							
							if(labor.consumer.wageComplaint <= 0) {
								break;
							}
						}
					}
				}
				// ȂꍇłA^[NA
//	 NOTE: ̐YH|ł悤ɏCƁAǂ炩̒ɃNAĂ܂
				labor.consumer.wageComplaint = 0;
			}
			
			// YpXgNA
			adjustList = new GoodsList();
			
			// ݌ɊmF
			GoodsList stockList = market.getStockList();
			for(int i=0; i < stockList.getSize(); i++) {
				// c菤i
				Goods tmpGoods = stockList.getGoods(i);
				
				if(tmpGoods.number > 0) {

					if(productList.getGoods(tmpGoods.name) != null) {
DU.s2("c̏i"+tmpGoods.name+""+tmpGoods.number+"܂B");
						
						// Yʂ1ȉɂ͂Ȃ
						if(productList.getGoods(tmpGoods.name).number == tmpGoods.number) {
							if(tmpGoods.number == 1) {
								continue;
							} else {
								--tmpGoods.number;	// CɌ炷ɂB
							}
							
						// ݌ɌJzlƃ}CiX̏ꍇ@Y<݌ɗʂ̏ꍇ@
						} else if(productList.getGoods(tmpGoods.name).number < tmpGoods.number) {
							tmpGoods.number = productList.getGoods(tmpGoods.name).number -1;
							if(tmpGoods.number == 0) {
								continue;
							} 
DU.s2(tmpGoods.name+"̐YʂPɂ܂B");
						}
						
						// Y \
						adjustList.addGoods(new Goods(
								tmpGoods.name, tmpGoods.number, tmpGoods.price));

//	YʕύX
DU.s2("ŁA"+tmpGoods.name+""+tmpGoods.number+"Y邱Ƃɂ悤Ǝv܂B");
					} //else {//戵i}
				}
			}
			
			
			// ]ƈ̘Jʂꍇ 
			for(int i=0; i < laborList.getSize(); i++) {
				Person labor = laborList.getPerson(i);
				
				// Bx % ȏ ̎莝ݕꍇ
				if((labor.consumer.getAchievement() >= Setting.decreaseLaborRate)
						&& (labor.consumer.wallet > 0)) {
					
					// z͒ڂȂ
					long leftoverWallet = labor.consumer.wallet;

					// Y鏤iI
					for(int j=0; j < adjustList.getSize(); j++) {
						Goods adjustGoods = adjustList.getGoods(j);
						
						if(adjustGoods.number > 0) {
			
							// Jʂ猸Yʂ
							long decreaseValue = leftoverWallet / adjustGoods.price;
							if(decreaseValue <= 0) {
								continue;	
							}

							decreaseValue = Math.min(adjustGoods.number, decreaseValue);
DU.s2("J҂̍zcƑk"+adjustGoods.name+"A"+decreaseValue+"Y邱Ƃɂ܂B");

							// }CiXɂȂȂ悤
							if(labor.labor.getWage() <= (decreaseValue * adjustGoods.price)) {
								decreaseValue = labor.labor.getWage() / adjustGoods.price;							
								if(decreaseValue <= 0) {
									continue;
								}
DU.s2("J҂̖̒lʁAC"+decreaseValue+"Y邱Ƃɂ܂B");
							}
							
							// Yʂ1ȉɂȂȂ悤Ɂ@
							//@ȂƂP͐YVXe iݒ̂ȌZ
							// 炩adjustListGoodsɂ͗]TĂ
							Goods productGoods = productList.getGoods(adjustGoods.name);
							if(productGoods != null) {
								
								// Yʌ
								if((productGoods.number - decreaseValue) < 1) {
									continue;
								} else {
									productList.getGoods(adjustGoods.name).number -= decreaseValue;
								}
								labor.labor.setWage(labor.labor.getWage()
										- (decreaseValue * adjustGoods.price));
								adjustGoods.number -= decreaseValue;
								leftoverWallet -= decreaseValue * adjustGoods.price;

//	YʕύX
DU.s2("J"+labor.name+"̒́A"+decreaseValue * adjustGoods.price+"A"+labor.labor.getWage()+"ɂȂ܂B");
DU.s2("i"+adjustGoods.name+"̐Yʂ́A"+productList.getGoods(adjustGoods.name).number+"ɒ܂B");

							}
						} // if Y鏤i
					}
				}
			} // for labor
		}
		
	}
	
}


// s
class Market {

	// ݌ɏi
	private GoodsList stockList = new GoodsList();
	private PersonList entryPersonList = new PersonList();

	// sɎQ  propensity͏%A0ȏ 100ȉ
	public void entry(Person p) {
	
		// *
		if(Setting.balanceForward) {
			p.consumer.wallet += (long)(p.labor.getWage() * p.consumer.getPropensity());	// Jz
			// TODO bug Jzł propensity1ȊOƁAɌJzȂz
			// 炱ł͏vZȂقǂ̂H
		} else {
			p.consumer.wallet = (long)(p.labor.getWage() * p.consumer.getPropensity()); // JzȂ
		}
		entryPersonList.addPerson(p);
	}

	public PersonList getEntryList() {
		return entryPersonList;
	}

	// YH݌ɗʂmFł
	public GoodsList getStockList() {
		return stockList;
	}
	
	// ݌ɐݒ
	public void setStockList(GoodsList goodsList) {
		for(int i=0; i < goodsList.getSize(); i++) {
			this.stockList.addGoods(goodsList.getGoods(i));
		}
	}
	
	// 
	public void exchange() {

		// _
		if(Setting.exchangeRandom) {
			entryPersonList.sortRandomOrder();
		}
		
		// [̎
		for(int i=0; i < entryPersonList.getSize(); i++) {
			// ̂̑I
			Person p = entryPersonList.getOrderedPerson(i);
			// ҂iڂI
			// z̒gȂĂpbZ[W𐶐
			p.consumer.browseAndPurchase(stockList);
		}
	}
	
	// ݌ɃNA
	public void clearStockList() {
		stockList = new GoodsList(); 
	}

	// ڋqNA
	public void clearEntryList() {
		entryPersonList = new PersonList(); 
	}
}


// i@ݕƌ鑼AbZ[Wpɂgp
class Goods {
	String name;	// i
	String maker; // 
	long number; // 
	long price;	// =l@v̏ꍇ-1Zbg
	
	// RXgN^
	Goods(String name, long number, long price) {
		this.name = name;
		this.number = number;
		this.price = price;
	}
}

class GoodsList {
	
	private ArrayList goodsList = new ArrayList();
	
	// XgGoodsǉ
	public void addGoods(Goods goods) {
		
		if(goods.name != null) {
			// OEzꍇAʏXV
			Goods tmpGoods = getGoods(goods.name);
			if((tmpGoods != null) && (tmpGoods.price == goods.price)) {
				getGoods(goods.name).number += goods.number;
			} else {
				goodsList.add(goods);
			}
		}
	}
	
	// ސ
	public int getSize() {
		return goodsList.size();
	}

	// iXgɂȂꍇA߂lnull
	public Goods getGoods(String name) {
		for(int i=0; i < goodsList.size(); i++) {
			if(((Goods)goodsList.get(i)).name.equals(name)) {
				return (Goods)goodsList.get(i);
			}
		}
		 return null;
	}
	// uEYp
	public Goods getGoods(int i){
		return (Goods)goodsList.get(i);
	}
	
	// 
	public GoodsList copyList(GoodsList newList) {
		for(int i=0; i < goodsList.size(); i++) {
			Goods goods = (Goods)goodsList.get(i);
			Goods newGoods = new Goods(goods.name, goods.number, goods.price);
			newList.addGoods(newGoods);
		}
		return newList;
	}
}


// 
class Person {
	
	public String name;
	
	// J
	Labor labor;

	// 
	Consumer consumer;

	// RXgN^
	Person(String name , long wage, double propensity) {
		this.name = name;
		this.labor = new Labor(wage);
		this.consumer = new Consumer();
		this.consumer.setPropensity(propensity);
	}
	
	// J
	public class Labor {
		// 
		private long wage = 0;
		
		Labor(long wage){
			this.wage = wage;
		}
		
		public long getWage() {
			return this.wage;
		}
		
		public void setWage(long initWage) {
			this.wage = initWage;
		}
	}
	

	// 
	public class Consumer {
		
		// 
		private double propensity;
		
		// Bx %
		private double achievement = 0;
		
		// vXgiP^[ɕKvȑvʁjiiʂ̃Xgj
		private GoodsList demandList = new GoodsList();

		//wςݏiXg
		private GoodsList purchaseList = new GoodsList();

		// z@*-wz
		long wallet = 0;
		
		// vȂiXg@ŎQƂpublic
		public GoodsList demandComplaint = new GoodsList(); 
		
		// ̕sz
		long wageComplaint = 0;
		
		// Marketentry
		int entryOrder = 0;
		
		public void setDemand(String goods, long number) {
			demandList.addGoods(new Goods(goods, number, -1));
		}
		
		public void clearDemandList() {
			demandList = new GoodsList();
		}
		
		public void clearDemandComplaint() {
			this.demandComplaint = new GoodsList();
		}

		public void clearPurchaseList() {
			purchaseList = new GoodsList();
		}
		
		public double getAchievement() {
			return this.achievement;
		}

		public void setPropensity(double propensity) {
			this.propensity = propensity;
		}
		
		public double getPropensity() {
			return this.propensity;
		}
		
		// Bx % vZ
		public void setAchievement() {
			
			double demandValue = 0;
			double achieveValue = 0;

			for(int i=0; i < demandList.getSize(); i++) {
				Goods demandGoods = demandList.getGoods(i);
				Goods purchaseGoods = purchaseList.getGoods(demandGoods.name);
		
				// wzZ
				if(purchaseGoods != null) {
					demandValue += purchaseGoods.number * purchaseGoods.price;
					achieveValue += purchaseGoods.number * purchaseGoods.price;		
				}

				demandValue += demandGoods.number * demandGoods.price;
			}
			
			this.achievement = (achieveValue / demandValue) * 100;
		}
		
		// w iIɕł鏤iI
		public void browseAndPurchase(GoodsList goodsList) {

			// iIgoodsListuEY
			for(int i=0; i < demandList.getSize(); i++) {
				Goods demandGoods = demandList.getGoods(i);

				// ړȈiT
				for(int j=0; j < goodsList.getSize(); j++) {
					Goods stockGoods = goodsList.getGoods(j);

					if(demandGoods.name.equals(stockGoods.name)) {
						// wEbZ[W̐
						purchase(stockGoods, demandGoods);
					}
				}
			}
			
			// BxvZ
			setAchievement();

			if(getAchievement() >= 100) {
				wageComplaint =  0;

			} else {
				//@sz = v̂wz - zc
				for(int i=0; i < demandList.getSize(); i++) {
					Goods demandGoods = demandList.getGoods(i);
					wageComplaint += demandGoods.price * demandGoods.number;
				}
				wageComplaint -=  wallet;
				
				// add 8.12 zɗݐώcꍇ̑Ή
				if(wageComplaint < 0) {
					wageComplaint =  0;
	DU.d1("wageComplaint: reset 0", true);
				}
			}
		}

		// w
		private void purchase(Goods stockGoods, Goods demandGoods) {

			// wӎv
			if(stockGoods.name.equals(demandGoods.name)
					&& (demandGoods.number > 0)) {
				
				// włȂĂiݒ
				demandGoods.price = stockGoods.price;
				Goods priceGoods = new Goods(demandGoods.name, 
						0, stockGoods.price);
				purchaseList.addGoods(priceGoods);
				
				// ݌ɐ̊mF
				if(stockGoods.number >= demandGoods.number) {
					
					// zƑk
					if(wallet >= (demandGoods.number * stockGoods.price)) {
					
						// z
						wallet -= (demandGoods.number * stockGoods.price);
						
						// wi
						Goods purchaseGoods = new Goods(demandGoods.name, 
								demandGoods.number, stockGoods.price);
						purchaseList.addGoods(purchaseGoods);
		
						stockGoods.number -= demandGoods.number;	// ݌Ɍ
						demandGoods.number -= demandGoods.number;	// v
						
					// z̒gsĂꍇ
					// w\w
					} else {
						// wvZ _ȉ؎̂
						long purchaseNum = wallet / stockGoods.price;
			
						if (purchaseNum > 0) {
							// z
							wallet -= (purchaseNum * stockGoods.price);
							
							// wi
							Goods purchaseGoods = new Goods(demandGoods.name, 
									purchaseNum, stockGoods.price);
							purchaseList.addGoods(purchaseGoods);
			
							stockGoods.number -= purchaseNum;	// ݌Ɍ
							demandGoods.number -= purchaseNum;	// v
						}
					}
					
				// ߎv
				// w\Ȑʂ܂łw
				} else {
					// s@vs
					Goods excessDemand = new Goods(demandGoods.name, 
							(demandGoods.number - stockGoods.number), stockGoods.price);
					demandComplaint.addGoods(excessDemand);

					// ݌ɂȂꍇ
					if(stockGoods.number == 0) {
						// dH

					// ݌ɗʈȏ̎v̂Ŕ߂
					} else if(wallet >= (stockGoods.number * stockGoods.price)) {
						// z
						wallet -= (stockGoods.number * stockGoods.price);
						// wi
						Goods purchaseGoods = new Goods(demandGoods.name, 
								stockGoods.number, stockGoods.price);
						purchaseList.addGoods(purchaseGoods);

						demandGoods.number -= stockGoods.number;	// v
						stockGoods.number = 0;						// ݌0
						
					// ݌ɗʈȏ̎v͂邪A莝sȂ̂ōw\Ȕ͈͂Ŏ
					} else {
						
						// wvZ _ȉ؎̂
						long purchaseNum = wallet / stockGoods.price;
						
						if(purchaseNum > 0) {
							
							// z
							wallet -= (purchaseNum * stockGoods.price);
							
							// wi
							Goods purchaseGoods = new Goods(demandGoods.name, 
									purchaseNum, stockGoods.price);
							purchaseList.addGoods(purchaseGoods);
			
							demandGoods.number -= purchaseNum;		// v
							stockGoods.number -= purchaseNum;		// ݌Ɍ
						}
					}
				}
			}
		}
		
		// ʕ\AfobOp  type:1=demand, 2=purchase, 3=complain , output:\L
		public GoodsList printList(int type, boolean output){
			
			GoodsList list = new GoodsList();
			String listName = "";
			switch(type) {
				case 1: list = this.demandList; listName="dL"; break;
				case 2: list = this.purchaseList; listName="pL"; break;
				case 3: list = this.demandComplaint; listName="dC"; break;
				default: break;
			}
			
			if(output) {
				for(int i=0; i < list.getSize(); i++) {
					Goods g = list.getGoods(i);
					System.out.println(listName +": "+ g.name + " num=" + g.number + " p=" + g.price);
				}
			}
			return list;
		}
	}	
}

class PersonList {
	
	// entrỹXg
	private ArrayList personList = new ArrayList();

	//@entrỹXgւXg
	private ArrayList orderedList = new ArrayList();

	// orderedList̏Ԃւ
	public void sortRandomOrder(){
		ArrayList tmpList = new ArrayList();
		Random random = new Random();

		orderedList.clear();
		tmpList = (ArrayList)personList.clone(); 
		
		for(int i=0; i < getSize(); i++) {
			int index = random.nextInt(tmpList.size());
			orderedList.add((Person)tmpList.get(index));
			tmpList.remove(index);
		}
	}
	
	//
	public Person getOrderedPerson(int i) {
		return (Person)orderedList.get(i);
	}	
	
	public Person getPerson(int i) {
		return (Person)personList.get(i);
	}
	
	public void addPerson(Person person) {
		orderedList.add(person);
		personList.add(person);
	}
	
	public int getSize() {
		return personList.size();
	}
}

/*
 * TODO
 * JavaDoc
 * Ot֐̃f[^long
 * Oťh@HTML܂pdfňĂPy[WPɁ@rł悤ȃTlC
 * \[XR[hϐC
 * package
 * słH
 * 
 */
